/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include "BaseDecoderUtils.h"

#include <vnccommon/StaticUtils.h>

DecoderSupportInfoDeallocator::DecoderSupportInfoDeallocator(
        BaseDecoderSupport& supportingApi,
        VNCCommonDecoderSupportInfo& supportInfo,
        const size_t supportInfoSize)

    :   mSupportingApi(supportingApi),
        mSupportInfo(supportInfo),
        mSupportInfoSize(supportInfoSize),
        mShouldFree(true)
{
}

void DecoderSupportInfoDeallocator::release()
{
    mShouldFree = false;
}

DecoderSupportInfoDeallocator::~DecoderSupportInfoDeallocator()
{
    if(!mShouldFree)
    {
        return;
    }

    if(VNCCOMMON_DOES_STRUCT_CONTAIN_MEMBER(
            VNCCommonDecoderSupportInfo,
            mSupportInfoSize,
            char*,
            decoderName))
    {
        if(mSupportInfo.decoderName != NULL)
        {
            mSupportingApi.supportingApiFreeString(
                    mSupportInfo.decoderName);

            mSupportInfo.decoderName = NULL;
        }
    }

    if(VNCCOMMON_DOES_STRUCT_CONTAIN_MEMBER(
            VNCCommonDecoderSupportInfo,
            mSupportInfoSize,
            char*,
            decoderVersion))
    {
        if(mSupportInfo.decoderVersion != NULL)
        {
            mSupportingApi.supportingApiFreeString(
                    mSupportInfo.decoderVersion);

            mSupportInfo.decoderVersion = NULL;
        }
    }
}

